<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Special Promotions Rules Duration by Amasty
 */

namespace Amasty\RulesDuration\Plugin;

use Magento\Framework\App\ProductMetadataInterface;
use Magento\Framework\EntityManager\MetadataPool;
use Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use Magento\SalesRule\Api\Data\RuleInterface;
use Magento\SalesRule\Model\ResourceModel\Rule\Collection;

class AddTimeFilter
{
    /**
     * @var TimezoneInterface
     */
    private $date;

    /**
     * @var MetadataPool
     */
    private $metadata;

    /**
     * @var ProductMetadataInterface
     */
    private $productMetadata;

    public function __construct(
        TimezoneInterface $date,
        MetadataPool $metadataPool,
        ProductMetadataInterface $productMetadata
    ) {
        $this->date = $date;
        $this->metadata = $metadataPool;
        $this->productMetadata = $productMetadata;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     * @param Collection $subject
     * @param Collection $result
     * @param int|string $websiteId
     * @param int|string $customerGroupId
     * @param string|null $couponCode
     * @return Collection
     */
    public function afterSetValidationFilter(
        Collection $subject,
        Collection $result,
        $websiteId,
        $customerGroupId,
        ?string $couponCode
    ): Collection {
        if ($this->productMetadata->getEdition() === 'Enterprise') {
            return $result;
        }

        $currentTime = $this->date->date(null, null, false)->format('Y-m-d H:i:s');

        $amRuleTable = $result->getTable('amasty_amrules_rule');
        $linkField = $this->metadata->getMetadata(RuleInterface::class)->getLinkField();
        $condString = $couponCode
            ? ($amRuleTable . '.salesrule_id = ' . 't.' . $linkField)
            : ($amRuleTable . '.salesrule_id = ' . 'main_table.' . $linkField);

        $result->getSelect()
            ->joinLeft(
                [$amRuleTable],
                $condString
            )
            ->where('from_datetime is null or from_datetime <= ?', $currentTime)
            ->where('to_datetime is null or to_datetime >= ?', $currentTime);

        return $result;
    }
}
