<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Special Promotions Rules Duration by Amasty
 */

namespace Amasty\RulesDuration\Model\SalesRule;

use Amasty\Rules\Model\ResourceModel\Rule;
use Amasty\Rules\Model\RuleProvider;
use Magento\Framework\App\ProductMetadataInterface;
use Magento\Framework\EntityManager\MetadataPool;
use Magento\Framework\EntityManager\Operation\ExtensionInterface;
use Magento\SalesRule\Api\Data\RuleInterface as SalesRuleInterface;

class ReadHandler implements ExtensionInterface
{
    /**
     * @var Rule
     */
    private $ruleResource;

    /**
     * @var MetadataPool
     */
    private $metadataPool;

    /**
     * @var ProductMetadataInterface
     */
    private $productMetadata;

    /**
     * @var RuleProvider
     */
    private $ruleProvider;

    public function __construct(
        MetadataPool $metadataPool,
        ProductMetadataInterface $productMetadata,
        RuleProvider $ruleProvider
    ) {
        $this->metadataPool = $metadataPool;
        $this->productMetadata = $productMetadata;
        $this->ruleProvider = $ruleProvider;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     *
     * @param \Magento\SalesRule\Model\Rule|\Magento\SalesRule\Model\Data\Rule $entity
     * @param array $arguments
     *
     * @return \Magento\SalesRule\Model\Rule|\Magento\SalesRule\Model\Data\Rule
     */
    public function execute($entity, $arguments = [])
    {
        if ($this->productMetadata->getEdition() === 'Enterprise') {
            return $entity;
        }

        $linkField = $this->metadataPool->getMetadata(SalesRuleInterface::class)->getLinkField();
        $ruleLinkId = (int)$entity->getDataByKey($linkField);

        if ($ruleLinkId) {
            $amRule = $this->ruleProvider->getAmruleByRuleId($ruleLinkId);
            $fromDatetime = $amRule->getData('from_datetime');
            $toDatetime = $amRule->getData('to_datetime');
            if ($fromDatetime) {
                $entity->setData('from_date', $fromDatetime);
            }
            if ($toDatetime) {
                $entity->setData('to_date', $toDatetime);
            }
        }

        return $entity;
    }
}
