<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Special Promotions Conditions by Amasty
 */

namespace Amasty\RulesConditions\Observer\Admin;

use Amasty\RulesConditions\Model\Rule\Condition\SalesRule;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class AddNewConditionHandle implements ObserverInterface
{
    /**
     * @var RequestInterface
     */
    private $request;

    public function __construct(RequestInterface $request)
    {
        $this->request = $request;
    }

    public function execute(Observer $observer): void
    {
        $moduleName = $this->request->getModuleName();
        if ($moduleName === 'sales_rule') {
            $additional = $observer->getAdditional();
            $conditions = $additional->getConditions();

            if (!is_array($conditions)) {
                $conditions = [];
            }

            $conditions[] = [
                'label' => __('Cart Price Rules'),
                'value' => [
                    [
                        'value' => SalesRule::class,
                        'label' => __('Applied Cart Price Rule'),
                    ]
                ]
            ];
            $additional->setConditions($conditions);
        }
    }
}
