<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Special Promotions Conditions by Amasty
 */

namespace Amasty\RulesConditions\Model\OptionProvider;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Framework\DB\Select;
use Magento\SalesRule\Model\ResourceModel\Rule\CollectionFactory;

class SalesRuleOptionProvider implements OptionSourceInterface
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    public function __construct(
        CollectionFactory $collectionFactory
    ) {
        $this->collectionFactory = $collectionFactory;
    }

    public function toOptionArray(): array
    {
        $options = [];

        $collection = $this->collectionFactory->create();
        $collection->getSelect()
            ->reset(Select::COLUMNS)
            ->columns(['rule_id', 'name']);
        foreach ($collection->getData() as $rule) {
            $options[] = [
                'value' => $rule['rule_id'],
                'label' => $rule['name']
            ];
        }

        return $options;
    }
}
