<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Amasty_SocialToBuilder
*/


declare(strict_types=1);

namespace Amasty\SocialToBuilder\Setup\Patch\Data;

use Amasty\ReportBuilder\Model\Template\ExampleReport;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class SocialSummaryReportData implements DataPatchInterface
{
    public const MODULE_NAME = 'Amasty_SocialToBuilder';

    /**
     * @var ExampleReport
     */
    private $exampleReport;

    public function __construct(
        ExampleReport $exampleReport
    ) {
        $this->exampleReport = $exampleReport;
    }

    public static function getDependencies(): array
    {
        return [];
    }

    public function getAliases(): array
    {
        return [];
    }

    /**
     * @return $this
     */
    public function apply()
    {
        $this->exampleReport->createExampleReports(self::MODULE_NAME);
        
        return $this;
    }
}
