<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package One Step Checkout MFTF 3 for Magento 2 (System)
 */

namespace Amasty\CheckoutMFTF3\Test\Mftf\Helper;

use Facebook\WebDriver\Remote\RemoteWebDriver as FacebookWebDriver;
use Facebook\WebDriver\WebDriverBy;
use Magento\FunctionalTestingFramework\Helper\Helper;
use Magento\FunctionalTestingFramework\Module\MagentoWebDriver;

/**
 * Class for MFTF helpers for OneStepCheckout module.
 */
class OSCCustomHelper extends Helper
{

    /** Enable Custom Field
     *
     * @param string $addNewCustomField
     * @param string $newCustomFieldCheckbox
     * @param string $buttonSubmit
     * @param string $customField
     * @param string $numberEnabledCheckoutField
     * @param string $url
     *
     * @return void
     */

    public function enableCustomField(
        string $addNewCustomField,
        string $newCustomFieldCheckbox,
        string $buttonSubmit,
        string $customField,
        string $numberEnabledCheckoutField,
        string $url
    ): void {
        try {
            /** @var MagentoWebDriver $webDriver */
            $magentoWebDriver = $this->getModule('\Magento\FunctionalTestingFramework\Module\MagentoWebDriver');
            /** @var FacebookWebDriver $webDriver */
            $webDriver = $magentoWebDriver->webDriver;
            $customFieldElement = $webDriver->findElements(WebDriverBy::xpath($customField));

            if ($customFieldElement) {
                $magentoWebDriver->dragAndDrop($customField,$numberEnabledCheckoutField);
            } else {
                $magentoWebDriver->click($addNewCustomField);
                $magentoWebDriver->waitForPageLoad(10);
                $magentoWebDriver->click($newCustomFieldCheckbox);
                $magentoWebDriver->checkOption($newCustomFieldCheckbox);
                $magentoWebDriver->click($buttonSubmit);
                $magentoWebDriver->waitForLoadingMaskToDisappear();
                $magentoWebDriver->amOnPage($url);
                $magentoWebDriver->waitForPageLoad();
            }
            echo "Custom Field Added to OSC" . PHP_EOL;
        } catch (\Exception $e) {
            $this->fail($e->getMessage());
        }
    }

    /** Change Config Value of Exist
     *
     * @param string $path
     * @param string $argument
     *
     * @return void
     */

    public function changeConfigIfExist(
        string $path,
        string $argument
    ): void {
        try {
            /** @var MagentoWebDriver $webDriver */
            $magentoWebDriver = $this->getModule('\Magento\FunctionalTestingFramework\Module\MagentoWebDriver');
            /** @var FacebookWebDriver $webDriver */
            $resp = $magentoWebDriver->magentoCLI('config:set ' . $path . ' ' . $argument);
            echo $resp . PHP_EOL;
        } catch (\Exception $e) {
            echo 'Configuration by path ' . $path . ' not found.' . PHP_EOL;
        }
    }
}
