<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shopby Setting Import Entity
 */

namespace Amasty\ShopbySettingImportEntity\Import\Validation\EntityValidator;

use Amasty\ImportCore\Api\Validation\FieldValidatorInterface;
use Magento\Framework\App\ResourceConnection;

class DuplicateFilterSetting implements FieldValidatorInterface
{
    /**
     * @var ResourceConnection
     */
    private $connection;

    /**
     * @var array
     */
    private $validationResult;

    public function __construct(ResourceConnection $connection)
    {
        $this->connection = $connection;
    }

    public function validate(array $row, string $field): bool
    {
        if (isset($row[$field])) {
            $attributeCode = trim($row[$field]);
            if (!empty($attributeCode)) {
                if (!isset($this->validationResult[$attributeCode])) {
                    $this->validationResult[$attributeCode] = $this->isSettingExists($attributeCode) === false;
                }

                return $this->validationResult[$attributeCode];
            }
        }

        return true;
    }

    private function isSettingExists(string $attributeCode): bool
    {
        $filterSettingTable = $this->connection->getTableName('amasty_amshopby_filter_setting');
        $connection = $this->connection->getConnection();

        return (bool)$connection->fetchOne(
            $connection->select()
                ->from($filterSettingTable)
                ->where('attribute_code = ?', $attributeCode)
                ->limit(1)
                ->columns(['setting_id'])
        );
    }
}
