<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shopby Setting Import Entity
 */

namespace Amasty\ShopbySettingImportEntity\Import\Validation\EntityValidator;

use Amasty\ImportCore\Api\Validation\FieldValidatorInterface;
use Magento\Framework\App\ResourceConnection;

class CategoriesFilter implements FieldValidatorInterface
{
    /**
     * @var ResourceConnection
     */
    private $connection;

    public function __construct(ResourceConnection $connection)
    {
        $this->connection = $connection;
    }

    public function validate(array $row, string $field): bool
    {
        if (isset($row[$field])) {
            $categoryIds = array_filter(explode(',', trim($row[$field])));
            if (!empty($categoryIds)) {
                return $this->isCategoryIdsCorrect($categoryIds);
            }
        }

        return true;
    }

    private function isCategoryIdsCorrect(array $categoryIds): bool
    {
        $categoryTable = $this->connection->getTableName('catalog_category_entity');
        $connection = $this->connection->getConnection();

        return count($categoryIds) === count(
            $connection->fetchCol(
                $connection->select()
                    ->from($categoryTable)
                    ->where('entity_id IN(?)', $categoryIds)
                    ->columns(['entity_id'])
            )
        );
    }
}
