<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shopby Setting Import Entity
 */

namespace Amasty\ShopbySettingImportEntity\Import\Validation\EntityValidator;

use Amasty\ImportCore\Api\Validation\FieldValidatorInterface;
use Magento\Catalog\Setup\CategorySetup;
use Magento\Framework\App\ResourceConnection;

class AttributesFilter implements FieldValidatorInterface
{
    /**
     * @var ResourceConnection
     */
    private $connection;

    public function __construct(ResourceConnection $connection)
    {
        $this->connection = $connection;
    }

    public function validate(array $row, string $field): bool
    {
        if (isset($row[$field])) {
            $attributeIds = array_filter(explode(',', trim($row[$field])));
            if (!empty($attributeIds)) {
                return $this->isAttributeIdsCorrect($attributeIds);
            }
        }

        return true;
    }

    private function isAttributeIdsCorrect(array $attributeIds): bool
    {
        $eavTable = $this->connection->getTableName('eav_attribute');
        $connection = $this->connection->getConnection();

        return count($attributeIds) === count(
            $connection->fetchCol(
                $connection->select()
                    ->from($eavTable)
                    ->where('attribute_id IN(?)', $attributeIds)
                    ->where('entity_type_id = ?', CategorySetup::CATALOG_PRODUCT_ENTITY_TYPE_ID)
                    ->columns(['attribute_id'])
            )
        );
    }
}
