<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shopby Setting Import Entity
 */

namespace Amasty\ShopbySettingImportEntity\Import\Validation\EntityValidator;

use Amasty\ImportCore\Api\Validation\FieldValidatorInterface;
use Magento\Framework\App\ResourceConnection;

class AttributeOptionsFilter implements FieldValidatorInterface
{
    /**
     * @var ResourceConnection
     */
    private $connection;

    public function __construct(ResourceConnection $connection)
    {
        $this->connection = $connection;
    }

    public function validate(array $row, string $field): bool
    {
        if (isset($row[$field])) {
            $attributeOptionIds = array_filter(explode(',', trim($row[$field])));
            if (!empty($attributeOptionIds)) {
                return $this->isAttributeOptionIdsCorrect($attributeOptionIds);
            }
        }

        return true;
    }

    private function isAttributeOptionIdsCorrect(array $attributeOptionIds): bool
    {
        $optionsTable = $this->connection->getTableName('eav_attribute_option_value');
        $connection = $this->connection->getConnection();

        return count($attributeOptionIds) === count(
            $connection->fetchCol(
                $connection->select()
                    ->from($optionsTable)
                    ->where('option_id IN(?)', $attributeOptionIds)
                    ->columns(['option_id'])
            )
        );
    }
}
