<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shopby Setting Import Entity
 */

namespace Amasty\ShopbySettingImportEntity\Import\Validation\EntityValidator;

use Amasty\ImportCore\Api\Validation\FieldValidatorInterface;
use Magento\Catalog\Setup\CategorySetup;
use Magento\Framework\App\ResourceConnection;

class AttributeCode implements FieldValidatorInterface
{
    /**
     * @var ResourceConnection
     */
    private $connection;

    /**
     * @var array
     */
    private $validationResult;

    public function __construct(ResourceConnection $connection)
    {
        $this->connection = $connection;
    }

    public function validate(array $row, string $field): bool
    {
        if (isset($row[$field])) {
            $attributeCode = trim($row[$field]);
            if (!empty($attributeCode)) {
                if (!isset($this->validationResult[$attributeCode])) {
                    $this->validationResult[$attributeCode] = $this->isAttributeExists($attributeCode);
                }

                return $this->validationResult[$attributeCode];
            }
        }

        return true;
    }

    private function isAttributeExists(string $attributeCode): bool
    {
        $eavTable = $this->connection->getTableName('eav_attribute');
        $connection = $this->connection->getConnection();

        return (bool)$connection->fetchOne(
            $connection->select()
                ->from($eavTable)
                ->where('attribute_code = ?', $attributeCode)
                ->where('entity_type_id = ?', CategorySetup::CATALOG_PRODUCT_ENTITY_TYPE_ID)
                ->limit(1)
                ->columns(['attribute_id'])
        );
    }
}
