<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shopby Setting Import Entity
 */

namespace Amasty\ShopbySettingImportEntity\Import\SourceOption;

use Magento\Framework\Data\OptionSourceInterface;

class DisplayMode implements OptionSourceInterface
{
    public const MODE_DEFAULT = 0;
    public const MODE_DROPDOWN = 1;
    public const MODE_SLIDER = 2;
    public const MODE_FROM_TO_ONLY = 3;
    public const MODE_IMAGES = 4;
    public const MODE_IMAGES_LABELS = 5;
    public const MODE_TEXT_SWATCH = 6;

    public function toOptionArray(): array
    {
        return [
            [
                'value' => self::MODE_DEFAULT,
                'label' => __('Labels')
            ],
            [
                'value' => self::MODE_DROPDOWN,
                'label' => __('Dropdown')
            ],
            [
                'value' => self::MODE_IMAGES,
                'label' => __('Images')
            ],
            [
                'value' => self::MODE_IMAGES_LABELS,
                'label' => __('Images & Labels')
            ],
            [
                'value' => self::MODE_TEXT_SWATCH,
                'label' => __('Text Swatches')
            ],
            [
                'value' => self::MODE_SLIDER,
                'label' => __('Slider')
            ],
            [
                'value' => self::MODE_FROM_TO_ONLY,
                'label' => __('From-To Only')
            ]
        ];
    }
}
