<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Improved Layered Navigation MFTF 3 for Magento 2 (System)
 */

namespace Amasty\ShopbyMFTF3\Plugin\Catalog\Helper\Product\ProductList;

use Amasty\Base\Model\MagentoVersion;
use Magento\Catalog\Helper\Product\ProductList;

/**
 * Bug fix situation when enabled 'All' limiter and magento tries to bring the phrase to int and a fatal occurs
 */
class FixBugWithLimiter
{
    private const NUMBER_FOR_ALL_LIMITER = 999;

    /**
     * @var MagentoVersion
     */
    private $magentoVersion;

    public function __construct(MagentoVersion $magentoVersion)
    {
        $this->magentoVersion = $magentoVersion;
    }

    /**
     * @see ProductList::getAvailableLimit()
     */
    public function afterGetAvailableLimit(ProductList $subject, array $result): array
    {
        foreach ($result as $key => $limiter) {
            if (version_compare($this->magentoVersion->get(), '2.4.5', '>=')
                && $key === 'all'
                && $limiter instanceof \Magento\Framework\Phrase
            ) {
                $result[$key] = self::NUMBER_FOR_ALL_LIMITER;
            }
        }

        return $result;
    }
}
