<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop By Hyva Compatibility
 */

declare(strict_types=1);

namespace Amasty\ShopbyHyvaCompatibility\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Amasty\Shopby\Model\ConfigProvider;

class JsInit implements ArgumentInterface
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @param ConfigProvider $configProvider
     */
    public function __construct(
        ConfigProvider $configProvider
    ) {
        $this->configProvider = $configProvider;
    }

    /**
     * Check is stickysidebar enabled
     *
     * @return bool
     */
    public function getEnableStickySidebarDesktop(): bool
    {
        return $this->configProvider->isEnableStickySidebarDesktop();
    }

    /**
     * Check is Single Choice Mode enabled
     *
     * @return bool
     */
    public function isSingleChoiceMode(): bool
    {
        return $this->configProvider->isSingleChoiceMode();
    }
}
