<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Shopby Grouped Options Hyva for Magento 2
 */

declare(strict_types=1);

namespace Amasty\ShopbyGroupedOptionsHyva\Plugin\ViewModel;

use Amasty\GroupedOptions\Model\GroupAttr\DataProvider;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class ProductListAjax
{
    /**
     * @var DataProvider
     */
    private $dataProvider;

    /**
     * Constructor
     *
     * @param DataProvider $dataProvider
     */
    public function __construct(
        DataProvider $dataProvider
    ) {
        $this->dataProvider = $dataProvider;
    }

    /**
     * Apply grouped options logic to the product list ajax
     *
     * @param ArgumentInterface $subject
     * @param string $result
     * @param int $attributeId
     * @param string $groupCode
     * @return string
     */
    public function afterGetGroupsByAttributeId(
        ArgumentInterface $subject,
        string $result,
        int $attributeId,
        string $groupCode
    ): string {
        $value = [];

        $groups = $this->dataProvider->getGroupsByAttributeId($attributeId);
        foreach ($groups as $group) {
            if ($group['group_code'] === $groupCode) {
                foreach ($group->getOptions() as $option) {
                    $value[] = (int)$option['option_id'];
                }
            }
        }

        return implode(',', $value);
    }
}
