<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Plugin\Shopby\Model\ResourceModel\Fulltext\Collection\SearchCriteriaResolver;

use Amasty\Shopby\Model\ResourceModel\Fulltext\Collection;
use Amasty\Shopby\Model\ResourceModel\Fulltext\Collection\SearchCriteriaResolver;
use Magento\CatalogSearch\Model\ResourceModel\Fulltext\Collection\SearchCriteriaResolver as MysqlSearchCriteriaResolver;
use Magento\Elasticsearch\Model\ResourceModel\Fulltext\Collection\SearchCriteriaResolver
    as ElasticSearchCriteriaResolver;
use Magento\Framework\Search\EngineResolverInterface;
use Magento\LiveSearchAdapter\Model\ResourceModel\Fulltext\Collection\SearchCriteriaResolver
    as LiveSearchCriteriaResolver;
use Magento\LiveSearchAdapter\Model\ResourceModel\Fulltext\Collection\SearchCriteriaResolverFactory
    as SearchCriteriaResolverFactory;

class GetLiveSearchSearchCriteriaResolver
{
    /**
     * @var EngineResolverInterface
     */
    private $engineResolver;

    /**
     * @var SearchCriteriaResolverFactory
     */
    private $liveSearchCriteriaResolverFactory;

    public function __construct(
        EngineResolverInterface $engineResolver,
        SearchCriteriaResolverFactory $liveSearchCriteriaResolverFactory
    ) {
        $this->engineResolver = $engineResolver;
        $this->liveSearchCriteriaResolverFactory = $liveSearchCriteriaResolverFactory;
    }

    /**
     * @param SearchCriteriaResolver $subject
     * @param callable $proceed
     * @param array $data
     * @return MysqlSearchCriteriaResolver|ElasticSearchCriteriaResolver|LiveSearchCriteriaResolver
     */
    public function aroundGetResolver(SearchCriteriaResolver $subject, callable $proceed, array $data)
    {
        if ($this->engineResolver->getCurrentSearchEngine() == Collection::LIVESEARCH_ENGINE) {
            return $this->liveSearchCriteriaResolverFactory->create($data);
        }

        return $proceed($data);
    }
}
