<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Plugin\Shopby\Model\ResourceModel\Fulltext\Collection;

use Amasty\Shopby\Model\Layer\Filter\Rating;
use Amasty\Shopby\Model\ResourceModel\Fulltext\Collection;

class ReplaceFilterValue
{
    private const RATING_DELTA = 1;

    /**
     * @param Collection $collection
     * @param string $attributeCode
     * @param string|array $condition
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeAddFieldToFilter(Collection $collection, $attributeCode, $condition): array
    {
        if ($attributeCode === Rating::ATTRIBUTE_CODE) {
            $attributeCode .= '.from';
            $condition = array_search($condition, Rating::STARS) ?: $condition;
            $condition -= self::RATING_DELTA; // because from filter work as greater instead of greater or equals
        }

        return [$attributeCode, $condition];
    }
}
