<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Plugin\Shopby\Model\ResourceModel\Fulltext\Collection;

use Amasty\Shopby\Helper\Category as CategoryHelper;
use Amasty\Shopby\Model\ResourceModel\Fulltext\Collection;

class DisableChangeCategory
{
    /**
     * Disable change category id in search request. Because not support render all tree yet.
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeGetMemSearchCriteria(Collection $subject, array $filter = []): array
    {
        unset($filter[CategoryHelper::ATTRIBUTE_CODE]);
        return [$filter];
    }
}
