<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Plugin\Shopby\Helper\Category;

use Amasty\Shopby\Helper\Category as CategoryHelper;
use Magento\Catalog\Model\Category;

class ChangeStartCategory
{
    /**
     * Use current category. Because support only render children tree.
     * @see \Amasty\ShopByLiveSearch\Plugin\Shopby\Model\ResourceModel\Fulltext\Collection\DisableChangeCategory
     */
    public function afterGetStartCategory(CategoryHelper $subject): Category
    {
        return $subject->getLayer()->getCurrentCategory();
    }
}
