<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Plugin\LiveSearchAdapter\Model\QueryArgumentProcessor\FilterHandler;

use Amasty\Shopby\Model\Search\RequestGenerator as ShopbyRequestGenerator;
use Magento\LiveSearchAdapter\Model\QueryArgumentProcessor\FilterHandler\FilterHandlerFactory;
use Magento\LiveSearchAdapter\Model\QueryArgumentProcessor\FilterHandler\FilterHandlerInterface;

class ResolveAndLogic
{
    /**
     * If filter use AND logic , we need split filter by attribute.
     * Example: need {"attribute":color, "in":["Black"], "attribute":color, "in":["Blue"]} instead of
     * {"attribute":color, "in":["Black", "Blue"]}
     *
     * @param FilterHandlerFactory $filterHandlerFactory
     * @param array $args Use dynamic args because parameters count different on different versions of live search.
     *
     * @see FilterHandlerFactory::resolve
     * @see \Amasty\Shopby\Model\Layer\Filter\Attribute::getFakeAttributeCodeForApply
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeResolve(
        FilterHandlerFactory $filterHandlerFactory,
        ...$args
    ): array {
        $regexp = sprintf('@%s[0-9]+@', ShopbyRequestGenerator::FAKE_SUFFIX);
        foreach ($args as $key => $arg) {
            if (is_string($arg)) {
                $newArg = preg_replace($regexp, '', $arg);
                if ($newArg !== $arg) {
                    $args[$key] = $newArg;
                    break;
                }
            }
        }

        return $args;
    }
}
