<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Plugin\LiveSearchAdapter\Model\AttributeMetadata;

use Amasty\ShopByLiveSearch\Model\Attribute\Options\OptionsProvider;
use Magento\LiveSearchAdapter\Model\AttributeMetadata;

class AddCustomFiltersOptions
{
    /**
     * @var OptionsProvider
     */
    private $optionsProvider;

    public function __construct(OptionsProvider $optionsProvider)
    {
        $this->optionsProvider = $optionsProvider;
    }

    /**
     * @param AttributeMetadata $subject
     * @param string[] $attributeMetadata
     * @param string[] $attributeCodes
     * @return string[]
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetAttributesMetadata(
        AttributeMetadata $subject,
        array $attributeMetadata,
        array $attributeCodes
    ): array {
        $customFiltersCodes = $this->optionsProvider->getAvailableFilterCodes();
        $customFiltersCodes = array_intersect($customFiltersCodes, $attributeCodes);

        foreach ($customFiltersCodes as $customFilterCode) {
            $options = $this->optionsProvider->getOptions($customFilterCode);
            foreach ($options as $optionId) {
                $attributeMetadata[$customFilterCode]['options']['admin'][$optionId] = (string) $optionId;
            }
        }

        return $attributeMetadata;
    }
}
