<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Plugin\DataExporter\Export\Processor;

use Amasty\ShopByLiveSearch\Model\Product\CustomFilterPool;
use Magento\DataExporter\Export\Processor;
use Magento\DataExporter\Model\Indexer\FeedIndexMetadata;
use Magento\Store\Model\StoreManagerInterface;

class AddCustomFiltersValue
{
    /**
     * @var FeedIndexMetadata
     */
    private $productFeedMetadata;

    /**
     * @var CustomFilterPool
     */
    private $customFilterPool;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        FeedIndexMetadata $productFeedMetadata,
        CustomFilterPool $customFilterPool,
        StoreManagerInterface $storeManager
    ) {
        $this->productFeedMetadata = $productFeedMetadata;
        $this->customFilterPool = $customFilterPool;
        $this->storeManager = $storeManager;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterProcess(Processor $subject, array $data, string $feedName): array
    {
        if ($this->productFeedMetadata->getFeedName() === $feedName) {
            foreach ($data as &$productData) {
                foreach ($this->customFilterPool->execute() as $customFilterValueProvider) {
                    $attributeValueData = $customFilterValueProvider->execute(
                        $productData['productId'],
                        (int) $this->storeManager->getStore($productData['storeViewCode'])->getId()
                    );
                    $productData['attributes'][] = $attributeValueData;
                }
            }
        }

        return $data;
    }
}
