<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Plugin\DataExporter\Export\Processor;

use Amasty\Shopby\Model\Layer\CustomFilters;
use Amasty\ShopByLiveSearch\Model\Attribute\Metadata\CustomFilterPool;
use Magento\DataExporter\Export\Processor;
use Magento\DataExporter\Model\Indexer\FeedIndexMetadata;
use Magento\Store\Api\Data\StoreInterface;
use Magento\Store\Model\StoreManagerInterface;

class AddCustomFiltersMeta
{
    /**
     * @var FeedIndexMetadata
     */
    private $attributeFeedMetadata;

    /**
     * @var CustomFilterPool
     */
    private $customFilterPool;

    /**
     * @var CustomFilters
     */
    private $customFilters;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var StoreInterface[]
     */
    private $stores;

    public function __construct(
        FeedIndexMetadata $attributeFeedMetadata,
        CustomFilterPool $customFilterPool,
        CustomFilters $customFilters,
        StoreManagerInterface $storeManager
    ) {
        $this->attributeFeedMetadata = $attributeFeedMetadata;
        $this->customFilterPool = $customFilterPool;
        $this->customFilters = $customFilters;
        $this->storeManager = $storeManager;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterProcess(Processor $subject, array $data, string $feedName): array
    {
        if ($this->attributeFeedMetadata->getFeedName() === $feedName) {
            foreach ($this->customFilterPool->execute() as $customFilterCode => $customFilterMetadataProvider) {
                foreach ($this->getStores() as $store) {
                    $customFilterConfig = $this->customFilters->getConfig($customFilterCode, (int) $store->getId());
                    if (empty($customFilterConfig['enabled'])) {
                        continue;
                    }

                    $customFilterMetadata = $customFilterMetadataProvider->execute();
                    $customFilterMetadata['label'] = $customFilterConfig['label'];
                    $customFilterMetadata = $this->populateWithStoreData($customFilterMetadata, $store);

                    $data[] = $customFilterMetadata;
                }
            }
        }

        return $data;
    }

    /**
     * @return StoreInterface[]
     */
    private function getStores(): array
    {
        if ($this->stores === null) {
            $this->stores = $this->storeManager->getStores(false);
        }

        return $this->stores;
    }

    private function populateWithStoreData(array $customFilterMetadata, StoreInterface $store): array
    {
        $customFilterMetadata['storeViewCode'] = $store->getCode();
        $customFilterMetadata['storeCode'] = $store->getGroup()->getCode();
        $customFilterMetadata['websiteCode'] = $store->getWebsite()->getCode();

        return $customFilterMetadata;
    }
}
