<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Model\Product;

use Amasty\Shopby\Model\Layer\Filter\Stock as StockFilter;
use Amasty\Shopby\Plugin\Elasticsearch\Model\Adapter\DataMapper\StockStatus as StockStatusMapper;

class Stock implements CustomFilterValueInterface
{
    /**
     * @var CreateAttributeValue
     */
    private $createAttributeValue;

    /**
     * @var StockStatusMapper
     */
    private $stockStatusMapper;

    public function __construct(CreateAttributeValue $createAttributeValue, StockStatusMapper $stockStatusMapper)
    {
        $this->createAttributeValue = $createAttributeValue;
        $this->stockStatusMapper = $stockStatusMapper;
    }

    public function execute(int $entityId, int $storeId): array
    {
        $stockValue = $this->stockStatusMapper->map($entityId, [], $storeId, []);
        return $this->createAttributeValue->execute(
            StockFilter::ATTRIBUTE_CODE,
            [$stockValue[StockStatusMapper::FIELD_NAME]],
            [$stockValue[StockStatusMapper::FIELD_NAME]]
        );
    }
}
