<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Model\Product;

use Amasty\Shopby\Model\Layer\Filter\Rating as RatingFilter;
use Amasty\Shopby\Model\Search\DataProvider\Product\RatingProvider;

class Rating implements CustomFilterValueInterface
{
    /**
     * @var CreateAttributeValue
     */
    private $createAttributeValue;

    /**
     * @var RatingProvider
     */
    private $ratingProvider;

    public function __construct(CreateAttributeValue $createAttributeValue, RatingProvider $ratingProvider)
    {
        $this->createAttributeValue = $createAttributeValue;
        $this->ratingProvider = $ratingProvider;
    }

    public function execute(int $entityId, int $storeId): array
    {
        $productRating = $this->ratingProvider->getProductRating($entityId, $storeId);
        $productRatingId = $this->getProductRatingId($productRating);

        return $this->createAttributeValue->execute(
            RatingFilter::ATTRIBUTE_CODE,
            [$productRatingId],
            [$productRatingId]
        );
    }

    /**
     * Convert rating to lowest int value ID.
     * Example: 15 = 1, 22 = 2.
     */
    private function getProductRatingId(?int $productRating): int
    {
        $starsData = RatingFilter::STARS + [6 => 120];
        $fromRating = 0;
        foreach ($starsData as $id => $toRating) {
            if ($productRating >= $fromRating && $productRating < $toRating) {
                return $id - 1;
            }
            $fromRating = $toRating;
        }

        return RatingFilter::INVALID_RATING;
    }
}
