<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Model\Product;

use Amasty\Shopby\Model\Layer\Filter\OnSale as OnSaleFilter;
use Amasty\Shopby\Model\Search\DataProvider\Product\OnSaleProvider;
use Magento\Customer\Api\Data\GroupInterface;

class OnSale implements CustomFilterValueInterface
{
    /**
     * @var OnSaleProvider
     */
    private $onSaleProvider;

    /**
     * @var CreateAttributeValue
     */
    private $createAttributeValue;

    public function __construct(
        OnSaleProvider $onSaleProvider,
        CreateAttributeValue $createAttributeValue
    ) {
        $this->onSaleProvider = $onSaleProvider;
        $this->createAttributeValue = $createAttributeValue;
    }

    public function execute(int $entityId, int $storeId): array
    {
        $value = (int) $this->onSaleProvider->isProductOnSale(
            $entityId,
            $storeId,
            GroupInterface::NOT_LOGGED_IN_ID // livesearch doesn't support customer groups
        );

        return $this->createAttributeValue->execute(
            OnSaleFilter::ATTRIBUTE_CODE,
            [$value],
            [$value]
        );
    }
}
