<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Model\Product;

use Amasty\Shopby\Model\Layer\Filter\IsNew as IsNewFilter;
use Amasty\Shopby\Model\Search\DataProvider\Product\IsNewProvider;

class IsNew implements CustomFilterValueInterface
{
    /**
     * @var IsNewProvider
     */
    private $isNewProvider;

    /**
     * @var CreateAttributeValue
     */
    private $createAttributeValue;

    public function __construct(IsNewProvider $isNewProvider, CreateAttributeValue $createAttributeValue)
    {
        $this->isNewProvider = $isNewProvider;
        $this->createAttributeValue = $createAttributeValue;
    }

    public function execute(int $entityId, int $storeId): array
    {
        $value = (int) $this->isNewProvider->isProductNew($entityId, $storeId);
        return $this->createAttributeValue->execute(
            IsNewFilter::ATTRIBUTE_CODE,
            [$value],
            [$value]
        );
    }
}
