<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Model\Product;

class CustomFilterPool
{
    /**
     * @var CustomFilterValueInterface[]
     */
    private $customFilters;

    public function __construct(array $customFilters)
    {
        $this->customFilters = $customFilters;
    }

    /**
     * Return array value providers of all custom filters.
     *
     * @return CustomFilterValueInterface[]
     */
    public function execute(): array
    {
        return $this->customFilters;
    }
}
