<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Model\Attribute\Options;

class OptionsProvider
{
    /**
     * [
     *  'filer_code' => ['option_1', ...],
     *  ...
     * ]
     * @var array
     */
    private $options;

    public function __construct(array $options)
    {
        $this->options = $options;
    }

    /**
     * @return string[]
     */
    public function getOptions(string $filterCode): array
    {
        return $this->options[$filterCode] ?? [];
    }

    /**
     * @return string[]
     */
    public function getAvailableFilterCodes(): array
    {
        return array_keys($this->options);
    }
}
