<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Model\Attribute\Metadata;

use Amasty\Shopby\Model\Layer\Filter\Rating as RatingFilter;
use Amasty\ShopByLiveSearch\Model\Attribute\Options\OptionsProvider;

class Rating
{
    public const ATTRIBUTE_ID = 911122297;

    /**
     * @var DefaultMetadata
     */
    private $defaultMetadata;

    /**
     * @var OptionsProvider
     */
    private $optionsProvider;

    public function __construct(DefaultMetadata $defaultMetadata, OptionsProvider $optionsProvider)
    {
        $this->defaultMetadata = $defaultMetadata;
        $this->optionsProvider = $optionsProvider;
    }

    public function execute(): array
    {
        $attributeData = $this->defaultMetadata->execute();
        $attributeData['id'] = self::ATTRIBUTE_ID;
        $attributeData['attributeCode'] = RatingFilter::ATTRIBUTE_CODE;
        $attributeData['attributeOptions'] = $this->optionsProvider->getOptions(RatingFilter::ATTRIBUTE_CODE);

        return $attributeData;
    }
}
