<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Model\Attribute\Metadata;

use Amasty\Shopby\Model\Layer\Filter\OnSale as OnSaleFilter;
use Amasty\ShopByLiveSearch\Model\Attribute\Options\OptionsProvider;

class OnSale
{
    public const ATTRIBUTE_ID = 921122299;

    /**
     * @var DefaultMetadata
     */
    private $defaultMetadata;

    /**
     * @var OptionsProvider
     */
    private $optionsProvider;

    public function __construct(DefaultMetadata $defaultMetadata, OptionsProvider $optionsProvider)
    {
        $this->defaultMetadata = $defaultMetadata;
        $this->optionsProvider = $optionsProvider;
    }

    public function execute(): array
    {
        return array_merge($this->defaultMetadata->execute(), [
            'id' => self::ATTRIBUTE_ID,
            'attributeCode' => OnSaleFilter::ATTRIBUTE_CODE,
            'attributeOptions' => array_map('intval', $this->optionsProvider->getOptions(
                OnSaleFilter::ATTRIBUTE_CODE
            ))
        ]);
    }
}
