<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Model\Attribute\Metadata;

/**
 * Return default metadata , which applied for all our custom filters.
 */
class DefaultMetadata implements CustomFilterInterface
{
    public function execute(): array
    {
        return [
            'attributeType' => 'catalog_product',
            'dataType' => 'int',
            'multi' => false, // ??
            'frontendInput' => 'select',
            'required' => false,
            'unique' => false,
            'global' => false, // ??
            'visible' => true, // ??
            'searchable' => false, // ??
            'filterable' => true, // ??
            'visibleInCompareList' => false,
            'visibleInListing' => false,
            'sortable' => false,
            'visibleInSearch' => false,
            'filterableInSearch' => true, // ??
            'searchWeight' => 1.0,
            'usedForRules' => false,
            'boolean' => false,
            'systemAttribute' => false,
            'numeric' => false
        ];
    }
}
