<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package ILN Compatibility with Live Search for Magento 2 (System)
 */

namespace Amasty\ShopByLiveSearch\Model\Attribute\Metadata;

class CustomFilterPool
{
    /**
     * @var CustomFilterInterface[]
     */
    private $customFilters;

    public function __construct(array $customFilters)
    {
        $this->customFilters = $customFilters;
    }

    /**
     * Return array with metadata of all custom filters.
     *
     * @return CustomFilterInterface[]
     */
    public function execute(): array
    {
        return $this->customFilters;
    }
}
