<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop by Filter Highlight
 */

namespace Amasty\ShopByFilterHighlight\ViewModel;

use Amasty\ShopByFilterHighlight\Model\ConfigProvider;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class Highlight implements ArgumentInterface
{
    /**
     * @var ConfigProvider
     */
    private ConfigProvider $configProvider;

    public function __construct(
        ConfigProvider $configProvider
    ) {
        $this->configProvider = $configProvider;
    }

    public function getHighlightColor(): string
    {
        return $this->configProvider->getHighlightColor();
    }
}
