<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop by Filter Highlight
 */

namespace Amasty\ShopByFilterHighlight\Model\Source;

use Magento\Framework\Data\OptionSourceInterface;

class HighlightMode implements OptionSourceInterface
{
    public const AS_DEFAULT = 0;
    public const CUSTOM_HIGHLIGHT = 1;

    public function toOptionArray(): array
    {
        $options = [];
        foreach ($this->toArray() as $optionValue => $optionLabel) {
            $options[] = [
                'value' => $optionValue,
                'label' => $optionLabel
            ];
        }

        return $options;
    }

    public function toArray(): array
    {
        return [
            self::AS_DEFAULT => __('As Default'),
            self::CUSTOM_HIGHLIGHT => __('Custom Highlight'),
        ];
    }
}
