<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop by Filter Highlight
 */

namespace Amasty\ShopByFilterHighlight\Model;

use Amasty\Base\Model\ConfigProviderAbstract;
use Magento\Store\Model\ScopeInterface;

class ConfigProvider extends ConfigProviderAbstract
{
    public const HIGHLIGHT_COLOR = 'general/highlight_color';

    /**
     * @var string
     */
    protected $pathPrefix = 'amshopby/';

    public function getHighlightColor(?int $storeId = null, ?string $scope = ScopeInterface::SCOPE_STORE): string
    {
        return (string)$this->getValue(self::HIGHLIGHT_COLOR, $storeId, $scope);
    }
}
