<?php
declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop By Brand Compatibility with Hyva for Magento 2
 */

namespace Amasty\ShopByBrandHyvaCompatibility\ViewModel;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Store\Model\ScopeInterface;

class BrandsSliderGraphQlQuery implements ArgumentInterface
{
    /**
     * GraphQL query string
     *
     * @return string
     */
    public function queryString(): string
    {
        return 'ambrandslider(
                    displayZero: $displayZero,
                    sortBy: $sortBy
                  ) {
                    slider_header_color
                    items_number
                    items {
                      alt
                      brandId
                      img
                      label
                      position
                      url
                    }
                  }';
    }
}
