<?php
declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop By Brand Compatibility with Hyva for Magento 2
 */

namespace Amasty\ShopByBrandHyvaCompatibility\ViewModel;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Store\Model\ScopeInterface;

class BrandsPopupGraphQlQuery implements ArgumentInterface
{
    /**
     * Query String
     *
     * @return string
     */
    public function queryString(): string
    {
        return 'ambrandlist(
                    showCount: true
                    displayZero: true
                  ) {
                    all_letters,
                    items {
                      alt
                      brandId
                      cnt
                      image
                      img
                      label
                      letter
                      url
                    }
                  }
                  storeConfig {
                    amshopby_brand_general_brands_brands_popup,
                    amshopby_brand_general_menu_item_label,
                    amshopby_brand_general_brands_page,
                    amshopby_brand_general_topmenu_enabled,
                    amshopby_brand_general_brands_popup_config {
                      show_images,
                      display_zero,
                      filter_display_all,
                      image_width,
                      image_height,
                      show_filter,
                      show_count
                    }
                  }';
    }
}
