<?php
declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop By Brand Compatibility with Hyva for Magento 2
 */

namespace Amasty\ShopByBrandHyvaCompatibility\ViewModel;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Store\Model\ScopeInterface;

class BrandsPopup implements ArgumentInterface
{
    /** @var ScopeConfigInterface  */
    private $scopeConfig;

    /** @var UrlInterface  */
    private $url;

    /**
     * BrandPopup constructor
     *
     * @param ScopeConfigInterface $scopeConfig
     * @param UrlInterface $url
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        UrlInterface $url
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->url = $url;
    }

    /**
     * Check is link enabled
     *
     * @return bool
     */
    public function isLinkEnabled(): bool
    {
        $topMenuEnabled = $this->scopeConfig->getValue(
            'amshopby_brand/general/topmenu_enabled',
            ScopeInterface::SCOPE_STORE
        );

        $brandExist = $this->scopeConfig->getValue(
            'amshopby_brand/general/attribute_code',
            ScopeInterface::SCOPE_STORE
        );

        return (int)$topMenuEnabled !== 0 && $brandExist;
    }

    /**
     * Retrieve label from config
     *
     * @return string
     */
    public function getLabel(): string
    {
        return $this->scopeConfig->getValue(
            'amshopby_brand/general/menu_item_label',
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Check is images enabled in config
     *
     * @return bool
     */
    public function isShowImages(): bool
    {
        return $this->scopeConfig->isSetFlag(
            'amshopby_brand/general/brands_popup_config/show_images',
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Check is count enabled in config
     *
     * @return bool
     */
    public function isShowCount(): bool
    {
        return $this->scopeConfig->isSetFlag(
            'amshopby_brand/general/brands_popup_config/show_count',
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * All Brands page url
     *
     * @return string
     */
    public function getBrandsPageUrl(): string
    {
        $value = $this->scopeConfig->getValue(
            'amshopby_brand/general/brands_page',
            ScopeInterface::SCOPE_STORE
        );

        $data = explode('|', $value);

        return $this->url->getUrl($data[0]);
    }
}
