<?php
declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop By Brand Compatibility with Hyva for Magento 2
 */

namespace Amasty\ShopByBrandHyvaCompatibility\ViewModel;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Store\Model\ScopeInterface;

class BrandsMoreFromBrandGraphQlQuery implements ArgumentInterface
{
    /**
     * GraphQL query string
     *
     * @param int $productId
     * @return string
     */
    public function queryString(int $productId): string
    {
        return '
  amBrandGetMoreFromThisBrandBlock(productId: "'.$productId.'") {
    items {
        id
        name
        url_key
        url_suffix
        visibility
        status
        canonical_url
        image {
          label
          url
        }
        small_image {
          label
          url
        }
        url_rewrites {
          parameters {
            name
            value
          }
          url
        }
        price_range {
          minimum_price {
            final_price {
              value
            }
          }
          maximum_price {
            final_price {
              value
            }
          }
        }
    }
    title
  }
';
    }
}
