<?php
declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop By Brand Compatibility with Hyva for Magento 2
 */

namespace Amasty\ShopByBrandHyvaCompatibility\ViewModel;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Store\Model\ScopeInterface;

class BrandsListGraphQlQuery implements ArgumentInterface
{
    /**
     * GraphQL query string
     *
     * @return string
     */
    public function queryString(): string
    {
        return 'ambrandlist(
                    showCount: true
                    displayZero: true
                  ) {
                    all_letters
                    items {
                      alt
                      brandId
                      cnt
                      description
                      image
                      tooltip_content
                      img
                      label
                      letter
                      short_description
                      url
                    }
                  }';
    }
}
