<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop By Brand Compatibility with Hyva for Magento 2
 */
declare(strict_types=1);

namespace Amasty\ShopByBrandHyvaCompatibility\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;

class BrandsList implements ArgumentInterface
{
    /**
     * Convert data to JS params
     *
     * @param array $data
     * @return array
     */
    public function convertToJSParams(
        array $data = []
    ): array {
        $result = [];

        $map = [
            'showCount' => 'show_count',
            'showFilters' =>  'show_filter',
            'showBrandLogo' => 'show_images',
            'imageWidth' => 'image_width',
            'imageHeight' => 'image_height',
            'filterDisplayAll' => 'filter_display_all',
            'displayZero' => 'display_zero',
            'showSearch' => 'show_search',
            'columns' => 'columns'
        ];

        foreach ($map as $jsKey => $dataKey) {
            $result[$jsKey] = isset($data[$dataKey]) ? (int)$data[$dataKey] : 0;
        }

        return $result;
    }
}
