<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop By Brand Compatibility with Hyva for Magento 2
 */

namespace Amasty\ShopByBrandHyvaCompatibility\Plugin\Catalog\Block\Product\View;

use Amasty\ShopbyBrand\Model\ConfigProvider;
use Amasty\ShopbyBrand\ViewModel\OptionProcessor;
use Magento\Framework\View\Element\BlockFactory;
use Hyva\Theme\Service\CurrentTheme;

class BlockHtmlTitlePlugin extends \Amasty\ShopbyBrand\Plugin\Catalog\Block\Product\View\BlockHtmlTitlePlugin
{
    public const AMASTY_BRAND_ICON_ELEMENT_REGEX
        = '@\<div +?class="amshopby-option-link.*?">.*<\/div>@s';

    /**
     * @var CurrentTheme
     */
    private $currentTheme;

    /**
     * @param BlockFactory $blockFactory
     * @param ConfigProvider $configProvider
     * @param OptionProcessor $optionProcessor
     * @param CurrentTheme $currentTheme
     */
    public function __construct(
        BlockFactory $blockFactory,
        ConfigProvider $configProvider,
        OptionProcessor $optionProcessor,
        CurrentTheme $currentTheme
    ) {
        $this->currentTheme = $currentTheme;
        parent::__construct($blockFactory, $configProvider, $optionProcessor);
    }

    /**
     * Add Brand Label to Product Page
     *
     * @param \Magento\Theme\Block\Html\Title $original
     * @param string $html
     *
     * @return string
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterToHtml($original, $html)
    {
        if ($this->currentTheme->isHyva()) {
            $logoHtmlModified = '';
            $initialHtml = parent::afterToHtml($original, $html);
            if (preg_match(self::AMASTY_BRAND_ICON_ELEMENT_REGEX, $initialHtml, $matches)) {
                $logoHtmlModified = '<template x-data x-teleport=".product-info-main .title-font">'
                    . '<div class="product-brands-wrapper flex flex-wrap">'
                    . $matches[0]
                    . '</div>'
                    . '</template>';
            }
            return $html . $logoHtmlModified;
        }

        return parent::afterToHtml($original, $html);
    }
}
