<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop By Brand Compatibility with Hyva for Magento 2
 */
declare(strict_types=1);

namespace Amasty\ShopByBrandHyvaCompatibility\Model\Resolver;

use Amasty\ShopByBaseHyvaCompatibility\ViewModel\Tooltip;
use Amasty\ShopbyBrand\Model\Source\Tooltip as AmastyTooltip;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Store\Model\ScopeInterface;

class BrandTooltipContent implements ResolverInterface
{
    /** @var ScopeConfigInterface  */
    private $scopeConfig;

    /** @var Tooltip  */
    private $tooltipViewModel;

    /**
     * @param ScopeConfigInterface $scopeConfig
     * @param Tooltip $tooltipViewModel
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        Tooltip $tooltipViewModel
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->tooltipViewModel = $tooltipViewModel;
    }

    /**
     * Resolve multiple requests.
     *
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return string
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) : string {
        $tooltipAllowedPlaces = $this->scopeConfig->getValue(
            'amshopby_brand/general/tooltip_enabled',
            ScopeInterface::SCOPE_STORE
        );

        if (empty($tooltipAllowedPlaces)
            || !in_array(
                AmastyTooltip::ALL_BRAND_PAGE,
                explode(',', $tooltipAllowedPlaces)
            )) {
            return '';
        }

        return $this->tooltipViewModel->replaceCustomVariables(
            $this->scopeConfig->getValue(
                'amshopby_brand/general/tooltip_content',
                ScopeInterface::SCOPE_STORE
            ),
            $value
        );
    }
}
