<?php
declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shopby Base Hyva Compatibility (System)
 */

namespace Amasty\ShopByBaseHyvaCompatibility\Plugin;

use Amasty\ShopbyBase\Model\OptionSetting;
use Amasty\ShopbyBrand\ViewModel\OptionProcessor as AmastyOptionProcessor;
use Hyva\Theme\Service\CurrentTheme;

class OptionProcessor
{
    /** @var CurrentTheme  */
    private $currentTheme;

    /**
     * @param CurrentTheme $currentTheme
     */
    public function __construct(
        CurrentTheme $currentTheme
    ) {
        $this->currentTheme = $currentTheme;
    }

    /**
     * Additional data fro Hyva Theme
     *
     * @param AmastyOptionProcessor $subject
     * @param array $result
     * @param OptionSetting $setting
     * @return array
     */
    public function afterProcess(
        AmastyOptionProcessor $subject,
        array $result,
        OptionSetting $setting
    ): array {
        if (!$this->currentTheme->isHyva()) {
            return $result;
        }

        $result['_'] = [
            'label' => $setting->getLabel(),
            'img' => $setting->getSliderImageUrl(),
            'image' => $setting->getImageUrl(),
            'description' => $setting->getDescription(true),
            'short_description' => $setting->getShortDescription(),
        ];

        return $result;
    }
}
