<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shipping Table Rates MFTF 3 for Magento 2 (System)
 */

namespace Amasty\ShippingTableRatesMFTF3\Console\Command;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Console\Cli;
use Magento\Framework\Module\Dir;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class AssertExportFile extends Command
{
    const DESCRIPTION = "Return 'true' if shipping table rates export file is valid.";
    const PATH_TO_PATTERN = '/data/amstrates_rate_export.csv';
    const PATH_TO_FILE = '/rates.csv';

    /**
     * @var Dir
     */
    private $moduleDir;

    /**
     * @var DirectoryList
     */
    private $dir;

    public function __construct(
        Dir $moduleDir,
        DirectoryList $dir
    ) {
        parent::__construct();
        $this->moduleDir = $moduleDir;
        $this->dir = $dir;
    }

    public function getDescription(): string
    {
        return self::DESCRIPTION;
    }

    protected function configure(): void
    {
        parent::configure();
        $this->setName('mftf:rates:assert-export')
            ->setDescription($this->getDescription());
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $pathToExportPattern = $this->moduleDir->getDir('Amasty_ShippingTableRatesMFTF3')
            . self::PATH_TO_PATTERN;
        $path =  $this->dir->getRoot() . DIRECTORY_SEPARATOR . $this->dir::VAR_DIR . self::PATH_TO_FILE;

        try {
            $contentPattern = file_get_contents($pathToExportPattern);
            $contentResult = file_get_contents($path);

            $result = 'false';

            if (strpos($contentPattern, $contentResult) !== false){
                $result = 'true';
            }

        } catch (\Exception $e) {
            $output->writeln('<info>Error while get file. Files not found! Make sure of export or pattern files.</info>');

            return Cli::RETURN_FAILURE;
        }

        $output->writeln('<info> ' . $result . ' </info>');

        return Cli::RETURN_SUCCESS;
    }
}
