<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Seo Toolkit Lite GraphQl by Amasty
 */

namespace Amasty\SeoToolkitLiteGraphql\Model\Resolver\Product;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Store\Model\StoreManagerInterface;

class GetCanonical implements ResolverInterface
{
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        StoreManagerInterface $storeManager
    ) {
        $this->storeManager = $storeManager;
    }

    /**
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return string
     * @throws GraphQlInputException
     * @throws NoSuchEntityException
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ): string {
        if (!isset($value['model'])) {
            throw new GraphQlInputException(__('"model" must be specified'));
        }
        $product = $value['model'];
        $canonical = $product->getData($field->getName());
        $productUrl = $product->getUrlModel()->getUrl($product, ['_ignore_category' => true]);

        return $canonical
            ? $this->storeManager->getStore()->getBaseUrl() . ltrim($canonical, '/')
            : $productUrl;
    }
}
