<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package SEO Toolkit Base for Magento 2
 */

namespace Amasty\SeoToolkitLite\Model\Redirect;

use Amasty\SeoToolkitLite\Api\Data\RedirectInterface;
use Amasty\SeoToolkitLite\Api\Data\RedirectInterfaceFactory;
use Amasty\SeoToolkitLite\Model\Repository\RedirectRepository;
use Amasty\SeoToolkitLite\Model\ResourceModel\Redirect\Expiration;
use Magento\Framework\Stdlib\DateTime\DateTime;
use Magento\UrlRewrite\Service\V1\Data\UrlRewrite;

/**
 * Creates a redirect model Amasty\SeoToolkitLite\Model\Redirect and saves with the provided data
 */
class CreateRedirect
{
    /**
     * @var RedirectInterfaceFactory
     */
    private $redirectFactory;

    /**
     * @var RedirectRepository
     */
    private $redirectRepository;

    /**
     * @var DateTime
     */
    private $dateTime;

    /**
     * @var Expiration
     */
    private $expirationResource;

    public function __construct(
        RedirectInterfaceFactory $redirectFactory,
        RedirectRepository $redirectRepository,
        DateTime $dateTime,
        Expiration $expirationResource
    ) {
        $this->redirectFactory = $redirectFactory;
        $this->redirectRepository = $redirectRepository;
        $this->dateTime = $dateTime;
        $this->expirationResource = $expirationResource;
    }

    /**
     * @deprecated
     * @see withParams
     */
    public function execute(UrlRewrite $urlRewrite, string $targetPath, string $redirectType, string $lifetime): void
    {
        $this->withParams(
            (int)$urlRewrite->getStoreId(),
            $urlRewrite->getRequestPath(),
            $targetPath,
            $redirectType,
            $lifetime
        );
    }

    public function withParams(
        int $storeId,
        string $requestPath,
        string $targetPath,
        string $redirectType,
        string $lifetime
    ): void {
        $data = [
            RedirectInterface::IS_AUTOGENERATED => true,
            RedirectInterface::STATUS => 1,
            RedirectInterface::REQUEST_PATH => $requestPath,
            RedirectInterface::REDIRECT_TYPE => $redirectType,
            RedirectInterface::UNDEFINED_PAGE_ONLY => 0,
            RedirectInterface::PRIORITY => true,
            RedirectInterface::TARGET_PATH => $targetPath,
            'store_ids' => [$storeId]
        ];

        $redirect = $this->redirectFactory->create()->addData($data);
        $this->redirectRepository->save($redirect);
        $this->saveExpirationData($redirect->getRedirectId(), $lifetime);
    }

    private function saveExpirationData(int $redirectId, string $lifeTime): void
    {
        $daysString = sprintf('+%s days', $lifeTime);
        $expirationDate = $this->dateTime->date(null, $daysString);
        $this->expirationResource->saveExpirationData($redirectId, $expirationDate);
    }
}
