define([
    'mage/translate'
], function ($t) {
    'use strict';

    const STATUS_TOO_MANY_REQUESTS = 429;

    var mixin = {
        defaults: {
            messages: {
                rateLimitReached: $t('You have sent too many requests. Please try again later.'),
            }
        },

        searchProcess: function (value) {
            const jqxhr = this._super(value);

            jqxhr.fail((response) => {
                if (response.status !== STATUS_TOO_MANY_REQUESTS) {
                    return;
                }

                this.searchProducts([]);
                this.loading(false);
                this.message(this.messages.rateLimitReached);
            });
        }
    };

    return function (target) {
        return target.extend(mixin);
    };
});
