<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Search Rate Limiter by Amasty
 */

namespace Amasty\SearchRateLimiter\Plugin\Xsearch\Controller\Autocomplete;

use Amasty\SearchRateLimiter\Model\RateLimiter;
use Amasty\Xsearch\Controller\Autocomplete\Index;
use Magento\Framework\App\Response\Http;

class LockSearch
{
    public const HTTP_TOO_MANY_REQUESTS = 429;

    /**
     * @var RateLimiter
     */
    private $rateLimiter;

    /**
     * @var Http
     */
    private $response;

    public function __construct(
        RateLimiter $rateLimiter,
        Http $response
    ) {
        $this->rateLimiter = $rateLimiter;
        $this->response = $response;
    }

    public function beforeExecute(Index $subject): void
    {
        $rateLimiter = $this->rateLimiter->getLimiter(RateLimiter::SEARCH_LIMITER);

        if ($rateLimiter && !$rateLimiter->consume()->isAccepted()) {
            $subject->getRequest()->setQueryValue('q');
            $this->response->setStatusCode(self::HTTP_TOO_MANY_REQUESTS);
        }
    }
}
